package ga.core.individual;

import ga.core.validation.GAContext;

/**
 * This is the interface for individuals. It extends {@link IFitness}.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IIndividual<T extends IIndividual<T>> extends Cloneable,
    IFitness {
  // TODO there should be an Initializer class
  /**
   * Initializes the genotype randomly and resets the fitness.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void initRandomly();

  /**
   * Creates a new individual that is equal to this.
   * 
   * @return The clone.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public T clone();

  /**
   * Determines if the individual has been evaluated.
   * 
   * @return <code>true</code> if the individual is evaluated.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public boolean isEvaluated();

  /**
   * Getter for the unique id.
   * 
   * @return The id.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public long getId();

  /**
   * Sets the GA context.
   * 
   * @param context
   *          The context
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void setContext(GAContext context);

  /**
   * Getter for the GA context.
   * 
   * @return context The context
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public GAContext getContext();

}
